﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnTextBlockManipulationStarted(ByVal sender As Object,
                                               ByVal args As ManipulationStartedEventArgs)
        Dim destination = "/SecondPage.xaml"

        If TypeOf ContentPanel.Background Is SolidColorBrush Then
            Dim clr = (TryCast(ContentPanel.Background, SolidColorBrush)).Color
            destination &= String.Format("?Red={0}&Green={1}&Blue={2}",
                                         clr.R, clr.G, clr.B)
        End If

        Me.NavigationService.Navigate(New Uri(destination, UriKind.Relative))

        args.Complete()
        args.Handled = True
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background =
            New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(255)),
                                               CByte(rand.Next(255)),
                                               CByte(rand.Next(255))))

        MyBase.OnManipulationStarted(args)
    End Sub
End Class